require(['jquery', 'xwiki-meta'], function ($, xm) {
  'use strict';
  $(document).ready(function() {
    /**
     * Save the new user status.
     */
    var changeUserStatus = function (action) {
      var notification = new XWiki.widgets.Notification("\u0421\u043E\u0445\u0440\u0430\u043D\u0435\u043D\u0438\u0435...", 'inprogress');
      var url = new XWiki.Document(XWiki.Model.resolve('XWiki.Notifications.Code.NotificationPreferenceService', XWiki.EntityType.DOCUMENT)).getURL('get', 'outputSyntax=plain');
      $.post(url, {
        'action': action,
        'csrf': xm.form_token,
        'user': XWiki.Model.serialize(xm.documentReference),
        'target': 'user'
      }).done(function() {
        notification.hide();
        new XWiki.widgets.Notification("\u0413\u043E\u0442\u043E\u0432\u043E", 'done');
        if (action == 'watchUser') {
          $('.notificationWatchUserNotFollowing').addClass('hidden');
          $('.notificationWatchUserFollowing').removeClass('hidden')
        } else {
          $('.notificationWatchUserFollowing').addClass('hidden');
          $('.notificationWatchUserNotFollowing').removeClass('hidden');
        }
      }).fail(function() {
        notification.hide();
        new XWiki.widgets.Notification("\u041E\u0448\u0438\u0431\u043A\u0430 \u0441\u043E\u0445\u0440\u0430\u043D\u0435\u043D\u0438\u044F \u043D\u0430\u0441\u0442\u0440\u043E\u0435\u043A \u0443\u0432\u0435\u0434\u043E\u043C\u043B\u0435\u043D\u0438\u044F", 'error');
      });
    };

    var setUserDisableStatus = function(action) {
      var notification = new XWiki.widgets.Notification("\u0421\u043E\u0445\u0440\u0430\u043D\u0435\u043D\u0438\u0435...", 'inprogress');
      var url = new XWiki.Document(XWiki.Model.resolve('XWiki.XWikiUserProfileSheet', XWiki.EntityType.DOCUMENT)).getURL('get', 'outputSyntax=plain');
      $.post(url, {
        'action': action,
        'csrf': xm.form_token,
        'userId': XWiki.Model.serialize(xm.documentReference)
      }).done(function(data) {
        notification.hide();
        if (data.success) {
          new XWiki.widgets.Notification("\u0413\u043E\u0442\u043E\u0432\u043E", 'done');
          if (action == 'disable') {
            $('#disable').addClass('hidden');
            $('#enable').removeClass('hidden');
          } else {
            $('#disable').removeClass('hidden');
            $('#enable').addClass('hidden');
          }
        } else {
          new XWiki.widgets.Notification("\u041E\u0448\u0438\u0431\u043A\u0430 \u0441\u043E\u0445\u0440\u0430\u043D\u0435\u043D\u0438\u044F \u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u0435\u043B\u044C\u0441\u043A\u043E\u0433\u043E \u0441\u0442\u0430\u0442\u0443\u0441\u0430", 'error');
        }
      }).fail(function() {
        notification.hide();
        new XWiki.widgets.Notification("\u041E\u0448\u0438\u0431\u043A\u0430 \u0441\u043E\u0445\u0440\u0430\u043D\u0435\u043D\u0438\u044F \u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u0435\u043B\u044C\u0441\u043A\u043E\u0433\u043E \u0441\u0442\u0430\u0442\u0443\u0441\u0430", 'error');
      });
    };

    $('#disable').click(function (event) {
      setUserDisableStatus('disable');
    });

    $('#enable').click(function (event) {
      setUserDisableStatus('enable');
    });

    /**
     * DOM events
     */
    $('.notificationWatchUserAdd').click(function (event) {
      changeUserStatus('watchUser');
    });
    $('.notificationWatchUserRemove').click(function (event) {
      changeUserStatus('unwatchUser');
    });
  });
});
