require(['jquery'], function($) {
  var appNameInput = $('input[name="appName"]');
  var appParentInput = $('input[name="appParentReference"]');
  var preview = $('.appName-preview');
  var submitButton = $('#wizard-next').prop('disabled', true);

  var errorMessage = appNameInput.closest('dd').prev('dt').find('.xErrorMsg');
  if (errorMessage.size() == 0) {
    errorMessage = $(document.createElement('span')).addClass('xErrorMsg').hide().appendTo(errorMessage.addBack());
  }

  var toggleValidationError = function(message) {
    if (message) {
      appNameInput.addClass('xErrorField').focus();
      errorMessage.text(message).show();
    } else {
      appNameInput.removeClass('xErrorField');
      errorMessage.hide();
    }
  };

  var updatePreview = function(content) {
    preview.removeClass('loading').html(content);
    var error = preview.find('.xErrorMsg');
    submitButton.prop('disabled', error.size() > 0);
    toggleValidationError(error.remove().text());
  };

  var fetchPreviewUpdate = function() {
    if (appNameInput.val() == '') {
      updatePreview('<span class="xErrorMsg">\u041F\u043E\u0436\u0430\u043B\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u043D\u0430\u0437\u0432\u0430\u043D\u0438\u0435 \u043F\u0440\u0438\u043B\u043E\u0436\u0435\u043D\u0438\u044F.</span>');
    } else {
      preview.addClass('loading');
      $.get(XWiki.currentDocument.getURL('get'), submitButton.closest('form').serialize(), updatePreview);
    }
  };

  var previewTimeout;
  var schedulePreviewUpdate = function() {
    clearTimeout(previewTimeout);
    submitButton.prop('disabled', true);
    setTimeout(fetchPreviewUpdate, 500);
  };

  appNameInput.add(appParentInput)
    .on('input', schedulePreviewUpdate)
    .keyup(function(event) {
      // Show the error message if the user presses Enter before typing anything.
      if (event.which == 13 && appNameInput.val() == '' && !appNameInput.hasClass('xErrorField')) {
        fetchPreviewUpdate();
      }
    });
});
